<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class RetailPurchasePriceLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $name 物料名称 [ require false ]
     * @support  string $code 物料编码 [ require false ]
     * @support  int $supplierId 供应商id [ require false ]
     * @support  int $staffId 伙伴工号 [ require false ]
     * @support  string $createdAtStart 开始时间 [ require false ]
     * @support  string $createdAtEnd 结束时间 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchasePriceLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchasePriceLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}