<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method searchExpressDeliveriesByParams(array $params)
 * @method getExpressMapByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method updateByParams(array $params)
 */
class ExpressDeliveries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询基础快递单号
     *
     * @support  string $type 单据类型 [ require false ]
     * @support  string $parentNo 单据编号 [ require false ]
     * @support  string $trackingNumber 快递单号 [ require false ]
     * @support  int $relatedId 巨沃出库主单id [ require false ]
     * @support  int $relatedItemId 巨沃出库子单id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchExpressDeliveries () {
        return self::getClass()->searchExpressDeliveries([
        ]);
    }

    /**
     * 查询基础快递物流MAP
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExpressMap () {
        return self::getClass()->getExpressMap();
    }

    /**
     * 批量导入（excel导入更新)
     *
     * @support  array $items 快递单号列表 [ require false ]
     * @support  mixed $item  [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate([
        ]);
    }

    /**
     * 单个更新（在收货单中批量更新)
     *
     * @support  array $items 快递单号列表 [ require false ]
     * @support  mixed $item  [ require false ]
     * @support  string $expressType 上级单据类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ExpressDeliveries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ExpressDeliveries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}