<?php
namespace Mainto\Bridge\Enums\ProjectSupplyChain;

class ReceiveExceptionOrderStatusEnum {
    /**
     * 待发货人处理
     */
    const SENDER = 'sender';
    /**
     * 待门店处理
     */
    const STORE = 'store';
    /**
     * 待总仓处理
     */
    const WMS = 'wms';
    /**
     * 待发货人收货
     */
    const SENDER_RECEIVE = 'sender_receive';
    /**
     * 待门店收货
     */
    const STORE_RECEIVE = 'store_receive';
    /**
     * 完结
     */
    const END = 'end';
    /**
     * 驳回
     */
    const REJECT = 'reject';
    /**
     * 撤回
     */
    const REVOKE = 'revoke';
    /**
     * 列表展示数量的标签
     */
    const COUNT_SHOW = [0 => 'sender',1 => 'store',2 => 'sender_receive',3 => 'store_receive',4 => 'wms'];
    const TAG_MAP = ['all' => ['value' => '全部','count' => 0,'is_show' => false],'sender' => ['value' => '待发货人处理','count' => 0,'is_show' => true],'store' => ['value' => '待门店处理','count' => 0,'is_show' => true],'store_receive' => ['value' => '待门店确认','count' => 0,'is_show' => true],'sender_receive' => ['value' => '待发货人确认','count' => 0,'is_show' => true],'wms' => ['value' => '待总仓确认','count' => 0,'is_show' => true],'reject' => ['value' => '驳回','count' => 0,'is_show' => false],'end' => ['value' => '已完成','count' => 0,'is_show' => false]];
    const STATUS_MAP = ['store_receive' => '待门店确认','sender_receive' => '待发货人确认','store' => '待门店处理','sender' => '待发货人处理','wms' => '待总仓确认','end' => '已完成','reject' => '驳回'];
}