<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreateReq $params)
 * @method getCreatInfoByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreatInfoReq $params)
 * @method getDetailByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnDetailReq $params)
 * @method getListPaginationByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnPageReq $params)
 * @method approvalRevokeByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnApprovalRevokeReq $params)
 * @method updateStatusByParams(array $params)
 * @method updateReturnByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnUpdateReq $params)
 * @method callRetryReturnEbsByParams(array $params)
 */
class PurchaseReturn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建退货单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreateReq $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreateReq $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 创建前退货单明细
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreatInfoReq $query
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnCreateInfoRes
     */
    public static function getCreatInfo (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnCreatInfoReq $query) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCreatInfo($query),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnCreateInfoRes"
        );
    }


    /**
     * 获取退货单子单(退货单详情)
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnDetailReq $query
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnDetailRes
     */
    public static function getDetail (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnDetailReq $query) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getDetail($query),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnDetailRes"
        );
    }


    /**
     * 获取退货单分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnPageReq $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnPageListRes
     */
    public static function getListPagination (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnPageReq $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getListPagination($params),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\DTO\PurchaseReturnReturnPageListRes"
        );
    }


    /**
     * 撤回审批
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnApprovalRevokeReq $approvalRevokeReq
     * @throws  \Exception
     * @return  bool
     */
    public static function approvalRevoke (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnApprovalRevokeReq $approvalRevokeReq) {
        return self::getClass()->approvalRevoke($approvalRevokeReq);
    }


    /**
     * 更新状态
     *
     * @param  int $returnId 退货单id [ require true ]
     * @param  string $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStatus (int $returnId, string $status) {
        return self::getClass()->updateStatus([
            "returnId" => $returnId,
            "status" => $status,
        ]);
    }

    /**
     * 更新退货单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnUpdateReq $approvalRevokeReq
     * @throws  \Exception
     * @return  bool
     */
    public static function updateReturn (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseReturn\CMD\PurchaseReturnUpdateReq $approvalRevokeReq) {
        return self::getClass()->updateReturn($approvalRevokeReq);
    }


    /**
     * ebs重推方法
     *
     * @support  int $returnId 退货单主单id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function callRetryReturnEbs () {
        return self::getClass()->callRetryReturnEbs([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseReturn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseReturn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}