<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method closeByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method updateWaitCountByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method receiveByParams(array $params)
 * @method batchReceiveByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemLogByParams(array $params)
 * @method receiveListByParams(array $params)
 * @method exportByParams(array $params)
 * @method getLogisticsBySkuIdByParams(array $params)
 */
class Receive {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  string $noticeNo 发货通知单号 [ require false ]
     * @support  string $createdAtStart 创建开始时间 [ require false ]
     * @support  string $createdAtEnd 期望到货时间开始 [ require false ]
     * @support  string $arriveDateStart 期望到货时间结束 [ require false ]
     * @support  string $arriveDateEnd 创建结束时间 [ require false ]
     * @support  int $toStorageId 收货方id [ require false ]
     * @support  int $createBy 创建人工号 [ require false ]
     * @support  int $status 状态 [ require false ]
     * @support  string $demandNo 需求单号 [ require false ]
     * @support  string $orderNo 采购单号 [ require false ]
     * @support  int $toStorageId 收货方id [ require false ]
     * @support  array $materialIds 物料id [ require false ]
     * @support  int $fromStorageId 发货方id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @support  int $source 1自用/2零售 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 收货单详情
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $receiveId) {
        return self::getClass()->detail([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $receiveId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "receiveId" => $receiveId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 关闭收货单下面的子单
     *
     * @param  int $receiveId 收货单id [ require true ]
     * @support  array $items 收货单items列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $receiveId) {
        return self::getClass()->close([
            "receiveId" => $receiveId,
        ]);
    }

    /**
     * 批量关闭收货单
     *
     * @param  array $receiveIds 收货单IDs [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (array $receiveIds) {
        return self::getClass()->batchClose([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 更新待收货数量
     *
     * @param  array $data 收货数量信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateWaitCount (array $data) {
        return self::getClass()->updateWaitCount([
            "data" => $data,
        ]);
    }

    /**
     * 收货单导入模板
     *
     * @param  array $receiveIds 收货单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $receiveIds) {
        return self::getClass()->importTemplate([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 导入待收货数量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 批量收货
     *
     * @param  array $data 收货单信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receive (array $data) {
        return self::getClass()->receive([
            "data" => $data,
        ]);
    }

    /**
     * 批量整单收货
     *
     * @param  array $receiveIds 收货单IDs [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchReceive (array $receiveIds) {
        return self::getClass()->batchReceive([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 门店供应链 自用收货单列表
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $fromStorageId 发货仓库id [ require false ]
     * @support  string $trackingNumber 物流单号 [ require false ]
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  string $barcode 条形码 [ require false ]
     * @support  string $requestType 请求平台 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveList () {
        return self::getClass()->receiveList([
        ]);
    }

    /**
     * 收货单子单导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function export () {
        return self::getClass()->export([
        ]);
    }

    /**
     * sku查询未收获物流单号
     *
     * @support  int $skuId skuid [ require false ]
     * @support  int $source 来源 [ require true ]
     * @support  string $skuCode skucode [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLogisticsBySkuId () {
        return self::getClass()->getLogisticsBySkuId([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Receive');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Receive');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}