<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\CMD\BMSShipNoticeSearchCMD $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method importTemplateByParams(array $params)
 * @method importByParams(array $params)
 * @method importTrackingNumberByParams(array $params)
 * @method batchFullCloseByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method batchCloseByParams(array $params)
 * @method getCreateByInfosByParams(array $params)
 * @method getItemLogByParams(array $params)
 * @method expeditedByParams(array $params)
 * @method noticeSendTimesByParams(array $params)
 * @method batchPushByParams(array $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\CMD\BMSShipNoticeSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\CMD\BMSShipNoticeSearchCMD $CMD) {
        return self::getClass()->list($CMD);
    }


    /**
     * 详情
     *
     * @support  int $noticeId 发货通知单id [ require false ]
     * @support  string $noticeNo 发货通知单No [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeDetailDTO
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeDetailDTO"
        );
    }

    /**
     * 明细列表
     *
     * @param  int $noticeId 发货通知单id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipNoticeItemDTO[]
     */
    public static function itemList (int $noticeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->itemList([
                            "noticeId" => $noticeId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipNoticeItemDTO[]"
        );
    }

    /**
     * 发货通知单导入模板
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTemplate (array $noticeIds) {
        return self::getClass()->importTemplate([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 导入快递单号和数量
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function import (array $data) {
        return self::getClass()->import([
            "data" => $data,
        ]);
    }

    /**
     * 导入快递单号
     *
     * @param  array $data 数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function importTrackingNumber (array $data) {
        return self::getClass()->importTrackingNumber([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭发货主单
     *
     * @param  array $noticeIds 关闭的发货单IDs [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchFullClose (array $noticeIds) {
        return self::getClass()->batchFullClose([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 批量更新
     *
     * @param  array $data 待修改的信息 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 批量关闭
     *
     * @param  array $data 待关闭的信息 [ require true ]
     * @param  bool $check 是否校验预付款 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchClose (array $data, bool $check = true) {
        return self::getClass()->batchClose([
            "data" => $data,
            "check" => $check,
        ]);
    }

    /**
     * 获取创建人s
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCreateByInfos () {
        return self::getClass()->getCreateByInfos();
    }

    /**
     * 获取日志信息
     *
     * @param  int $entityId 数据id [ require true ]
     * @support  string $action 操作类型 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getItemLog (int $entityId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getItemLog([
            "entityId" => $entityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发货单-加急
     *
     * @support  array $noticeIds 发货通知单Id [ require false ]
     * @support  string $arriveDate 预计到货时间 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function expedited () {
        return self::getClass()->expedited([
        ]);
    }

    /**
     * 获取发货通知单所有的发货时间
     *
     * @param  int $noticeId 发货通知单Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipArriveStateItemDTO[]
     */
    public static function noticeSendTimes (int $noticeId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->noticeSendTimes([
                            "noticeId" => $noticeId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\ShipArriveStateItemDTO[]"
        );
    }

    /**
     * 发货通知单推送
     *
     * @param  array $noticeIds 发货通知单Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchPush (array $noticeIds) {
        return self::getClass()->batchPush([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}