<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array $params)
 * @method fromMainListByParams(array $params)
 * @method betweenStoreListByParams(array $params)
 * @method detailByParams(array $params)
 * @method detailItemListByParams(array $params)
 * @method batchCreateByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $params)
 * @method searchProductByParams(array $params)
 * @method searchItemsByParams(array $params)
 * @method closeAllocationItemByParams(array $params)
 * @method shipByParams(array $params)
 * @method exportBatchShipAddByParams(array $params)
 * @method allocationsRetryToEbsByParams(array $params)
 * @method receiveRetryToEbsByParams(array $params)
 * @method closeAllocationByAllocationIdsByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售-待处理调拨单数量
     *
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber () {
        return self::getClass()->waitDeliverNumber();
    }

    /**
     * 零售-调拨单列表
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  string $allocationType 单据类型 [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @support  int $searchAfter 当前页面的最大id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 零售-调拨单列表-总部调拨
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  string $allocationType 单据类型:from_main, from_supplier [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @support  int $searchAfter 当前页面的最大id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function fromMainList () {
        return self::getClass()->fromMainList([
        ]);
    }

    /**
     * 零售-调拨单列表-店间调拨
     *
     * @support  int $createType 调拨单创建方1是总部2是门店 [ require true ]
     * @support  string $allocationNo 调拨单号 [ require false ]
     * @support  string $allocationType 单据类型: between_store,return_main [ require false ]
     * @support  int $toStorageId 收货仓库id [ require false ]
     * @support  array $status 状态 1未发货，2部分发货，3部分发货完结，4完全发货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @support  int $searchAfter 当前页面的最大id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function betweenStoreList () {
        return self::getClass()->betweenStoreList([
        ]);
    }

    /**
     * 调拨单详情
     *
     * @param  int $id 调拨单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 调拨单详情页商品搜索
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailItemList () {
        return self::getClass()->detailItemList([
        ]);
    }

    /**
     * 新增批量调拨
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreate (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationBatchAddCMD $CMD) {
        return self::getClass()->batchCreate($CMD);
    }


    /**
     * 搜索商品-物料表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @param  int $storageId 搜索仓库 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword, int $storageId = 0) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
            "storageId" => $storageId,
        ]);
    }

    /**
     * 搜索商品-批量搜索物料库存
     *
     * @support  array $items items [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchItems () {
        return self::getClass()->searchItems([
        ]);
    }

    /**
     * 调拨单详情-关闭调拨单
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function closeAllocationItem () {
        return self::getClass()->closeAllocationItem([
        ]);
    }

    /**
     * 调拨单发货
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  array $itemList 调拨单sku列表 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  int $fromStaffId 发货人ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function ship () {
        return self::getClass()->ship([
        ]);
    }

    /**
     * 批量发货模板下载-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportBatchShipAdd () {
        return self::getClass()->exportBatchShipAdd([
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单
     *
     * @param  array $allocationNos 调拨单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function allocationsRetryToEbs (array $allocationNos) {
        return self::getClass()->allocationsRetryToEbs([
            "allocationNos" => $allocationNos,
        ]);
    }

    /**
     * 重试 推送ebs失败的调拨单-入仓
     *
     * @param  array $receiveIds 收货单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveRetryToEbs (array $receiveIds) {
        return self::getClass()->receiveRetryToEbs([
            "receiveIds" => $receiveIds,
        ]);
    }

    /**
     * 通过调拨单id关闭调拨单
     *
     * @param  array $allocationIds 调拨单id [ require true ]
     * @param  string $remark 备注 [ require false ]
     * @param  bool $isCheck 备注 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function closeAllocationByAllocationIds (array $allocationIds, string $remark = '', bool $isCheck = false) {
        return self::getClass()->closeAllocationByAllocationIds([
            "allocationIds" => $allocationIds,
            "remark" => $remark,
            "isCheck" => $isCheck,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}