<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailAllItemListByParams(array $params)
 * @method searchProductByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class RetailAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 调拨单详情页商品搜索-全量不分页
     *
     * @support  int $id 调拨单id [ require true ]
     * @support  string $skuName sku名字 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function detailAllItemList () {
        return self::getClass()->detailAllItemList([
        ]);
    }

    /**
     * 搜索商品-库存表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchProduct (string $keyword) {
        return self::getClass()->searchProduct([
            "keyword" => $keyword,
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\RetailAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}