<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method waitDeliverNumberByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $params)
 * @method searchMaterialByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 */
class SelfAllocation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 待处理调拨单数量
     *
     * @param  int $source 来源，1自用2零售 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function waitDeliverNumber (int $source) {
        return self::getClass()->waitDeliverNumber([
            "source" => $source,
        ]);
    }

    /**
     * 门店调拨单列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationPaginateSearchCMD $CMD) {
        return self::getClass()->list($CMD);
    }


    /**
     * 新增调拨并创建发货单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\Allocation\CMD\AllocationAddCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($CMD),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\DTO\CheckPassDTO"
        );
    }


    /**
     * 搜索物料-库存表搜
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Store\SelfAllocation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Store\SelfAllocation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}