<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Supplier;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method redPointByParams(array $params)
 * @method getShopCountByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method supplySystemItemListByParams(array $params)
 * @method supplySystemItemListHistoryByParams(array $params)
 * @method searchSupplySystemMaterialByParams(array $params)
 * @method getAllStorageByParams(array $params)
 * @method supplySessionTestByParams(array $params)
 * @method supplyNoticePredictByParams(array $params)
 */
class SupplierPurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 供应商协同-红点查看获取已逾期+加急的 发货单据数量
     *
     * @throws  \Exception
     * @return  int
     */
    public static function redPoint () {
        return self::getClass()->redPoint();
    }

    /**
     * 供应商协同-门店数
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getShopCount () {
        return self::getClass()->getShopCount();
    }

    /**
     * 批量发运
     *
     * @support  array $items 发货仓 [ require false ]
     * @support  mixed $item  [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSend () {
        return self::getClass()->batchSend([
        ]);
    }

    /**
     * 供应商协同-采购发货单-列表
     *
     * @support  string $sendDateStart 预计发货时间Start [ require false ]
     * @support  string $sendDateEnd 预计发货时间End [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间Start [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间End [ require false ]
     * @support  int $status 发货状态 [ require false ]
     * @support  array $skuIds 物料id [ require false ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @support  array $sort 列表排序 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplySystemItemList () {
        return self::getClass()->supplySystemItemList([
        ]);
    }

    /**
     * 供应商协同-采购发货单-历史列表
     *
     * @support  string $planShipDateAtStart 预计发货时间Start [ require false ]
     * @support  string $planShipDateAtEnd 预计发货时间End [ require false ]
     * @support  string $planLatestShipDateAtStart 最晚发货时间Start [ require false ]
     * @support  string $planLatestShipDateAtEnd 最晚发货时间End [ require false ]
     * @support  string $startShipTimeStart 开始发货时间Start [ require false ]
     * @support  string $startShipTimeEnd 开始发货时间End [ require false ]
     * @support  array $skuIds 物料id [ require false ]
     * @support  array $toStorageIds 收货方 [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplySystemItemListHistory () {
        return self::getClass()->supplySystemItemListHistory([
        ]);
    }

    /**
     * 供应商协同-供应商物料-物料搜索
     *
     * @support  string $keyword 搜索关键词 [ require false ]
     * @support  int $source 搜索关键词 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchSupplySystemMaterial () {
        return self::getClass()->searchSupplySystemMaterial([
        ]);
    }

    /**
     * 获取所有仓库
     *
     * @support  array $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStorage () {
        return self::getClass()->getAllStorage([
        ]);
    }

    /**
     * 功能测试
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function supplySessionTest () {
        return self::getClass()->supplySessionTest();
    }

    /**
     * supplyNoticePredict
     *
     * @param  int $fromStorageId 发货仓库 [ require true ]
     * @param  int $toStorageId 收货仓库 [ require true ]
     * @param  string $arriveDate 预计到达时间 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeItemPredictDTO[]
     */
    public static function supplyNoticePredict (int $fromStorageId, int $toStorageId, string $arriveDate) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->supplyNoticePredict([
                            "fromStorageId" => $fromStorageId,
                            "toStorageId" => $toStorageId,
                            "arriveDate" => $arriveDate,
                        ]),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ShipNotice\DTO\NoticeItemPredictDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Supplier\SupplierPurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Supplier\SupplierPurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}