<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoragesByParams(array $params)
 * @method getStorageByStoreIdByParams(array $params)
 * @method storageListByParams(array $params)
 * @method createStorageByStoreByParams(array $params)
 * @method createStorageBySupplierByParams(array $params)
 * @method getAllStorageByParams(array $params)
 * @method getStorageAddressByParams(array $params)
 * @method getListPageByParams(array $params)
 * @method getInfoByParams(array $params)
 * @method saveStorageInfoByParams(array $params)
 * @method openStoragePushWmsByParams(array $params)
 * @method endStoragePushWmsByParams(array $params)
 * @method getWmsCodeByParams(array $params)
 */
class Storage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取仓库s
     *
     * @support  array $sources 类型:4供应商,123为仓库 [ require false ]
     * @support  string $name 名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorages () {
        return self::getClass()->getStorages([
        ]);
    }

    /**
     * 根据门店获取对应仓库
     *
     * @support  int $storeId 门店ID [ require true ]
     * @support  int $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageByStoreId () {
        return self::getClass()->getStorageByStoreId([
        ]);
    }

    /**
     * 获取仓库列表
     *
     * @support  array $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 [ require false ]
     * @support  string $name 仓库名称 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function storageList () {
        return self::getClass()->storageList([
        ]);
    }

    /**
     * 创建门店仓库
     *
     * @param  int $id 门店id [ require true ]
     * @param  string $name 门店名 [ require true ]
     * @param  array $extend 收货地址 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStorageByStore (int $id, string $name, array $extend = []) {
        return self::getClass()->createStorageByStore([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 创建供应商仓库
     *
     * @param  int $id 供应商id [ require true ]
     * @param  string $name 供应商名 [ require true ]
     * @param  array $extend 供应商仓库地址 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStorageBySupplier (int $id, string $name, array $extend) {
        return self::getClass()->createStorageBySupplier([
            "id" => $id,
            "name" => $name,
            "extend" => $extend,
        ]);
    }

    /**
     * 获取所有仓库
     *
     * @support  array $source 仓库归属方 1是总部，2是门店，3是供应商 [ require false ]
     * @support  int $useType 仓库用途1是零售仓，2是自用仓 [ require false ]
     * @support  array $useTypes 仓库用途1是零售仓，2是自用仓，3门店虚拟仓 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllStorage () {
        return self::getClass()->getAllStorage([
        ]);
    }

    /**
     * 获取仓库地址
     *
     * @param  int $id 仓库id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStorageAddress (int $id) {
        return self::getClass()->getStorageAddress([
            "id" => $id,
        ]);
    }

    /**
     * 获取所有仓库
     *
     * @support  int $id 仓库id [ require false ]
     * @support  array $source 仓库类型[1是大江东仓,2是门店,3是供应商,4总部] [ require false ]
     * @support  int $useType 仓库用途 [1零售仓,2自用仓,3虚拟仓] [ require false ]
     * @support  array $useTypes 仓库用途 [1零售仓,2自用仓,3虚拟仓] [ require false ]
     * @support  int $storeId 门店id/部门id/供应商id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页记录数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getListPage () {
        return self::getClass()->getListPage([
        ]);
    }

    /**
     * 仓库详情
     *
     * @support  int $id 仓库id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo () {
        return self::getClass()->getInfo([
        ]);
    }

    /**
     * 修改仓库信息
     *
     * @support  int $id 仓库id [ require true ]
     * @support  string $province 省份 [ require true ]
     * @support  string $city 市 [ require true ]
     * @support  string $area 区县 [ require true ]
     * @support  string $address 详细地址 [ require true ]
     * @support  string $userName 收货人 [ require true ]
     * @support  string $phone 联系方式 [ require true ]
     * @support  int $selfLeadTime 自用发货期限 [ require false ]
     * @support  string $storeStartTime 门店开业时间 [ require false ]
     * @support  string $storeShippingTime 门店最晚发货时间 [ require false ]
     * @support  bool $expedited 是否立即发货 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveStorageInfo () {
        return self::getClass()->saveStorageInfo([
        ]);
    }

    /**
     * 设置仓库开启对接巨沃
     *
     * @support  int $storageId 仓库id [ require true ]
     * @support  string $warehouseCode 仓库code [ require false ]
     * @support  string $goodsOwner 货主 [ require false ]
     * @support  string $supplierCode 供应商code [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function openStoragePushWms () {
        return self::getClass()->openStoragePushWms([
        ]);
    }

    /**
     * 关闭仓库开启对接巨沃
     *
     * @support  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function endStoragePushWms () {
        return self::getClass()->endStoragePushWms([
        ]);
    }

    /**
     * 获取巨沃仓配置信息
     *
     * @support  int $storageId 仓库id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getWmsCode () {
        return self::getClass()->getWmsCode([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Storage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Storage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}