<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogisticDetailByParams(array $params)
 * @method getStoreOnlineCountByParams(array $params)
 */
class Logistic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据物流单号查询物流信息
     *
     * @support  string $logisticsNo 物流单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLogisticDetail () {
        return self::getClass()->getLogisticDetail([
        ]);
    }

    /**
     * 获取门店在途物流单数量
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getStoreOnlineCount () {
        return self::getClass()->getStoreOnlineCount();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Logistic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Logistic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}