<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method deleteByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method purchaseDemandExportAddByParams(array $params)
 * @method purchaseOrderExportAddByParams(array $params)
 * @method purchaseShipNoticeExportAddByParams(array $params)
 * @method retailUnsaleSkuExportAddByParams(array $params)
 * @method shipNoticeNewTaskByParams(array $params)
 * @method shipNoticeHistoryNewTaskByParams(array $params)
 * @method allocationNewTaskByParams(array $params)
 * @method allocationEndNewTaskByParams(array $params)
 * @method supplerListByParams(array $params)
 * @method supplerDeleteByParams(array $params)
 * @method purchaseRetailUnsalesByParams(array $params)
 */
class Export {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取列表 分页
     *
     * @support  string $template_id 导出模板id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 删除记录
     *
     * @support  array $task_ids 任务ids [ require false ]
     * @support  array $template_ids 模板ids [ require false ]
     * @param  bool $is_all 是否清除该伙伴所有的 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (bool $is_all = false) {
        return self::getClass()->delete([
            "is_all" => $is_all,
        ]);
    }

    /**
     * 新增导出任务 零售管理-采购单-导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * 新增导出任务 供应链管理-采购管理-需求单明细列表-导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function purchaseDemandExportAdd () {
        return self::getClass()->purchaseDemandExportAdd([
        ]);
    }

    /**
     * 新增导出任务 供应链管理-采购管理-采购订单-导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function purchaseOrderExportAdd () {
        return self::getClass()->purchaseOrderExportAdd([
        ]);
    }

    /**
     * 新增导出任务 供应链管理-采购管理-发货通知单-导出
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function purchaseShipNoticeExportAdd () {
        return self::getClass()->purchaseShipNoticeExportAdd([
        ]);
    }

    /**
     * 零售领用单
     *
     * @support  string $template_id 模板id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function retailUnsaleSkuExportAdd () {
        return self::getClass()->retailUnsaleSkuExportAdd([
        ]);
    }

    /**
     * 新增导出任务-供应商平台-发货通知单
     *
     * @support  array $params 参数 [ require false ]
     * @support  string $template_id Id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function shipNoticeNewTask () {
        return self::getClass()->shipNoticeNewTask([
        ]);
    }

    /**
     * 新增导出任务-供应商平台-历史发货通知单
     *
     * @support  array $params 参数 [ require false ]
     * @support  string $template_id Id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function shipNoticeHistoryNewTask () {
        return self::getClass()->shipNoticeHistoryNewTask([
        ]);
    }

    /**
     * 新增导出任务-供应商平台-调拨单
     *
     * @support  array $params 参数 [ require false ]
     * @support  string $template_id Id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function allocationNewTask () {
        return self::getClass()->allocationNewTask([
        ]);
    }

    /**
     * 新增导出任务-供应商平台-历史调拨单
     *
     * @support  array $params 参数 [ require false ]
     * @support  string $template_id Id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function allocationEndNewTask () {
        return self::getClass()->allocationEndNewTask([
        ]);
    }

    /**
     * (协同平台)获取列表 分页
     *
     * @support  string $template_id 导出模板id [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function supplerList () {
        return self::getClass()->supplerList([
        ]);
    }

    /**
     * (协同平台) 删除记录
     *
     * @support  array $task_ids 任务ids [ require false ]
     * @support  array $template_ids 模板ids [ require false ]
     * @param  bool $is_all 是否清除该伙伴所有的 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function supplerDelete (bool $is_all = false) {
        return self::getClass()->supplerDelete([
            "is_all" => $is_all,
        ]);
    }

    /**
     * 新增导出任务-供应商平台-零售零用单
     *
     * @support  array $params 参数 [ require false ]
     * @support  string $template_id Id [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function purchaseRetailUnsales () {
        return self::getClass()->purchaseRetailUnsales([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Export');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Export');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}