<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncFixedAssetByParams(array $params)
 * @method syncAssetCardByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $params)
 */
class FixedAsset {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步固定资产信息
     *
     * @param  string $assetNumber 资产编号 [ require false ]
     * @support  int $departmentId 部门id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $name 名称 [ require false ]
     * @support  int $locType 类型 [ require false ]
     * @support  int $onhand 数量 [ require false ]
     * @support  int $available 可用数量 [ require false ]
     * @support  string $serialNumber 资产序列号 [ require false ]
     * @support  string $lastDate 最后折旧时间 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  int $repairedTimes 维修次数 [ require false ]
     * @support  int $isInactive 是否无效 [ require false ]
     * @support  string $explain 备注 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function syncFixedAsset (string $assetNumber = '') {
        return self::getClass()->syncFixedAsset([
            "assetNumber" => $assetNumber,
        ]);
    }

    /**
     * 建卡出库
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $saveAssetCardOutCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncAssetCard (\Mainto\Bridge\Structs\ProjectSupplyChain\EasyInventory\Cmd\SaveAssetCardOutCmd $saveAssetCardOutCmd) {
        return self::getClass()->syncAssetCard($saveAssetCardOutCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'FixedAsset');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'FixedAsset');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}