<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createdByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params)
 * @method listPageByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params)
 */
class ProcessOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建加工单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params
     * @throws  \Exception
     * @return  array
     */
    public static function created (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params) {
        return self::getClass()->created($params);
    }


    /**
     * 创建加工单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderCreateDTO
     */
    public static function listPage (\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\Cmd\ProcessOrderCreateCmd $params) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->listPage($params),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\ProcessOrder\DTO\ProcessOrderCreateDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'ProcessOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'ProcessOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}