<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMaterialListByParams(array $params)
 * @method getMaterialByParams(array $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\SelfPurchaseDemandAddCMD $params)
 * @method getDemandListByParams(array $params)
 * @method detailByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method listByParams(array $params)
 * @method getBomProductsByParams(array $params)
 * @method stockListByParams(array $params)
 * @method stockInsideMoveByParams(array $params)
 * @method exportAddByParams(array $params)
 * @method stockCollectOutByParams(array $params)
 * @method stockFlowItemListByParams(array $params)
 * @method stockOtherOutByParams(array $params)
 * @method batchReceiveShipByParams(array $params)
 * @method searchMaterialByParams(array $params)
 * @method getStorageServiceByParams(array $params)
 * @method getStoragesByStaffIdByParams(array $params)
 * @method getDepartmentsByStaffIdByParams(array $params)
 * @method getRetailMaterialTemplateByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Material\Cmd\SearchCmd $params)
 */
class BmsMaterial {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物料列表(根据自用属性查询)
     *
     * @support  array $categoryIds 分类id数组 [ require false ]
     * @support  string $name 物料名称 [ require false ]
     * @support  int $productTagId 产品标签id [ require false ]
     * @param  int $page 当前页 [ require true ]
     * @param  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page, int $pageSize) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料采买sku详情
     *
     * @support  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial () {
        return self::getClass()->getMaterial([
        ]);
    }

    /**
     * 创建需求单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\SelfPurchaseDemandAddCMD $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\SelfPurchaseDemandAddCMD $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 需求单列表
     *
     * @support  string $type 类型 [ require false ]
     * @support  string $startTime 开始时间 [ require false ]
     * @support  string $endTime 结束时间 [ require false ]
     * @support  string $status 单据状态 [ require false ]
     * @support  int $createBy 申请人工号 [ require false ]
     * @support  int $skuId 物料skuId [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页记录数 [ require false ]
     * @support  int $departmentId 部门ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDemandList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getDemandList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 需求单详情
     *
     * @param  int $id 需求单id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * bms自用收货单列表
     *
     * @support  string $receiveNo 收货单号 [ require false ]
     * @support  int $fromStorageId 发货仓库id [ require false ]
     * @support  string $trackingNumber 物流单号 [ require false ]
     * @support  array $status 状态 1未收货，2部分收货，3部分收货完结，4完全收货，5关闭 [ require false ]
     * @support  string $skuName sku名称 [ require false ]
     * @support  string $skuCode sku编码 [ require false ]
     * @support  string $barcode 条形码 [ require false ]
     * @support  int $departmentId 部门ID [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * bom商品列表(bom编码和名称的获取) 自用
     *
     * @support  string $skuCode 商品skucode [ require false ]
     * @support  string $skuName 商品skuname [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBomProducts () {
        return self::getClass()->getBomProducts([
        ]);
    }

    /**
     * bms 职能采购库存列表
     *
     * @support  string $skuName sku名称 [ require false ]
     * @support  string $skuCode SKU编码 [ require false ]
     * @support  string $barcode 条形码 [ require false ]
     * @support  int $isFixedAsset 是否是固定资产, 0是，1不是 [ require false ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $departmentId 部门ID [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockList () {
        return self::getClass()->stockList([
        ]);
    }

    /**
     * bms 职能采购 库存-新增移库-零售仓内转移
     *
     * @support  string $fromCount 仓内调出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  string $toCount 仓内调入库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  int $departmentId 部门ID [ require true ]
     * @support  string $remark 备注 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockInsideMove () {
        return self::getClass()->stockInsideMove([
        ]);
    }

    /**
     * bms 职能采购 库存-导出查询结果
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function exportAdd () {
        return self::getClass()->exportAdd([
        ]);
    }

    /**
     * bms 职能采购 库存-领用出库
     *
     * @support  string $fromType 出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  int $memberId 自用物料领用人 [ require false ]
     * @support  string $receiver 其他出库收货人 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  int $departmentId 部门或者门店ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function stockCollectOut () {
        return self::getClass()->stockCollectOut([
        ]);
    }

    /**
     * bms 职能采购 库存-库存明细(库存子表维度：stock_flow_item)
     *
     * @support  int $skuId skuId [ require true ]
     * @support  int $page 当前页 [ require true ]
     * @support  int $storageId 仓库ID [ require true ]
     * @support  int $pageSize 页内条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockFlowItemList () {
        return self::getClass()->stockFlowItemList([
        ]);
    }

    /**
     * bms 职能采购 库存-新增其他出库
     *
     * @support  string $fromType 出库存类型：正品sale_usable_count 样品sample_usable_count 残次defective_count [ require true ]
     * @support  array $itemList 调整sku列表 [ require true ]
     * @support  int $memberId 自用物料领用人 [ require false ]
     * @support  string $receiver 其他出库收货人 [ require false ]
     * @support  string $remark 备注 [ require false ]
     * @support  int $departmentId 部门ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function stockOtherOut () {
        return self::getClass()->stockOtherOut([
        ]);
    }

    /**
     * bms自用收货操作-批量收货
     *
     * @support  array $data 发货单List [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchReceiveShip () {
        return self::getClass()->batchReceiveShip([
        ]);
    }

    /**
     * 库存-搜索物料
     *
     * @param  string $keyword 搜索关键词 [ require true ]
     * @support  int $departmentId 部门ID [ require true ]
     * @support  int $source 物料来源 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchMaterial (string $keyword) {
        return self::getClass()->searchMaterial([
            "keyword" => $keyword,
        ]);
    }

    /**
     * getStorageService
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getStorageService () {
        return self::getClass()->getStorageService();
    }

    /**
     * 获取员工对应的一级部门和对应的仓库，一对多关系
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getStoragesByStaffId () {
        return self::getClass()->getStoragesByStaffId();
    }

    /**
     * 获取员工对应的多部门
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getDepartmentsByStaffId () {
        return self::getClass()->getDepartmentsByStaffId();
    }

    /**
     * 零售需求单物料批量导入
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Material\Cmd\SearchCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function getRetailMaterialTemplate (\Mainto\Bridge\Structs\ProjectSupplyChain\Material\Cmd\SearchCmd $cmd) {
        return self::getClass()->getRetailMaterialTemplate($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'BmsMaterial');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}