<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain\Bms;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandAddCMD $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandSearchListCMD $params)
 * @method detailByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDCMD $params)
 * @method newTaskByParams(array $params)
 * @method batchDealByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDsCMD $params)
 * @method batchCloseByParams(array $params)
 * @method itemListByParams(array|\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandItemSearchListCMD $params)
 */
class RetailPurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建零售成品需求单
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandAddCMD $addCMD
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandAddCMD $addCMD) {
        return self::getClass()->create($addCMD);
    }


    /**
     * 需求单列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandSearchListCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandSearchListCMD $cmd) {
        return self::getClass()->list($cmd);
    }


    /**
     * 需求单详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDCMD $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function detail (\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDCMD $cmd) {
        return self::getClass()->detail($cmd);
    }


    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask([
        ]);
    }

    /**
     * 批量处理
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDsCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\RetailDemandDealDTO[]
     */
    public static function batchDeal (\Mainto\Bridge\Structs\ProjectSupplyChain\Basic\CMD\IDsCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->batchDeal($cmd),
            "\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\DTO\RetailDemandDealDTO[]"
        );
    }


    /**
     * 批量关闭
     *
     * @param  array $demandItemIds 需求单明细ids [ require true ]
     * @param  string $closeReason 关闭原因 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchClose (array $demandItemIds, string $closeReason) {
        return self::getClass()->batchClose([
            "demandItemIds" => $demandItemIds,
            "closeReason" => $closeReason,
        ]);
    }

    /**
     * 明细列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandItemSearchListCMD $params
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (\Mainto\Bridge\Structs\ProjectSupplyChain\PurchaseDemand\CMD\RetailPurchaseDemandItemSearchListCMD $params) {
        return self::getClass()->itemList($params);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Bms\RetailPurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}