<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method syncFixedAssetByParams(array $params)
 */
class FixedAsset {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 同步固定资产信息
     *
     * @param  string $assetNumber 资产编号 [ require true ]
     * @support  string $departmentId 部门id 
     * @support  string $storeId 门店id 
     * @support  string $name 名称 
     * @support  string $locType 类型 
     * @support  string $onhand 数量 
     * @support  string $available 可用数量 
     * @support  string $serialNumber 资产序列号 
     * @support  string $lastDate 最后折旧时间 
     * @support  string $status 状态 
     * @support  string $repairedTimes 维修次数 
     * @support  string $isInactive 是否无效 
     * @support  string $explain 备注 
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncFixedAsset (string $assetNumber = '') {
        return self::getClass()->syncFixedAsset([
            "assetNumber" => $assetNumber,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'FixedAsset');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'FixedAsset');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}