<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method itemListByParams(array $params)
 * @method updateByParams(array $params)
 * @method submitByParams(array $params)
 * @method closeByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class PurchaseOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  string $orderNo 采购单号 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $orderId) {
        return self::getClass()->detail([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 明细列表
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function itemList (int $orderId, int $page = 1, int $pageSize = 10) {
        return self::getClass()->itemList([
            "orderId" => $orderId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  int $supplierId 供应商id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $orderId, int $supplierId) {
        return self::getClass()->update([
            "orderId" => $orderId,
            "supplierId" => $supplierId,
        ]);
    }

    /**
     * 提交(生成发货通知单)
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (int $orderId) {
        return self::getClass()->submit([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $orderId 采购单id [Original type uint] [ require true ]
     * @param  array $orderItemIds 采购单明细id [ require true ]
     * @param  int $closeCount 关闭数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $orderId, array $orderItemIds, int $closeCount) {
        return self::getClass()->close([
            "orderId" => $orderId,
            "orderItemIds" => $orderItemIds,
            "closeCount" => $closeCount,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}