<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method isPurchaseTimeOrNotByParams(array $params)
 * @method autoUpdatePurchaseCountLimitByParams(array $params)
 * @method createPurchaseFormByParams(array $params)
 * @method getPurchaseListByParams(array $params)
 * @method getPurchaseByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method newTaskByParams(array $params)
 */
class PurchaseDemand {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 是否是采购时间
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function isPurchaseTimeOrNot () {
        return self::getClass()->isPurchaseTimeOrNot();
    }

    /**
     * 每个月自动更新门店物料的剩余采购数量
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoUpdatePurchaseCountLimit () {
        return self::getClass()->autoUpdatePurchaseCountLimit();
    }

    /**
     * 创建采购单
     *
     * @param  array $purchaseInfo 采购信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createPurchaseForm (array $purchaseInfo) {
        return self::getClass()->createPurchaseForm([
            "purchaseInfo" => $purchaseInfo,
        ]);
    }

    /**
     * 采购单列表
     *
     * @support  string $type 类型 
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 单据状态 
     * @support  int $staffId 申请人工号 [Original type uint] 
     * @support  int $skuId 物料skuId [Original type uint] 
     * @support  string $logisticsNumber 物流单号 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPurchaseList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPurchaseList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 采购单详情
     *
     * @param  int $id 采购单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPurchase (int $id) {
        return self::getClass()->getPurchase([
            "id" => $id,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseDemand');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseDemand');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}