<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method shelveSkuByParams(array $params)
 * @method unshelveSkuByParams(array $params)
 * @method removeSkuByParams(array $params)
 * @method recoverSkuByParams(array $params)
 * @method batchShelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method revokeByParams(array $params)
 * @method updateMainByParams(array $params)
 * @method batchUpdateMainByParams(array $params)
 * @method callbackDingProcessByParams(array $params)
 * @method syncMaterialSkuIdByParams(array $params)
 * @method getMaterialSkusByParams(array $params)
 * @method getMaterialListByParams(array $params)
 * @method getMaterialByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购员列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 创建物料
     *
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  int $isStockTaking 是否盘点 [Original type uint] 
     * @support  int $isFixedAsset 是否资产 [Original type uint] 
     * @support  int $fixedAssetType 资产类型 [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeType 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  int $isStockTaking 是否盘点 [Original type uint] 
     * @support  int $isFixedAsset 是否资产 [Original type uint] 
     * @support  int $fixedAssetType 资产类型 [Original type uint] 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据物料id获取sku信息
     *
     * @param  int $materialId 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialId (int $materialId) {
        return self::getClass()->getSkusByMaterialId([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 上架物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function shelve (int $id) {
        return self::getClass()->shelve([
            "id" => $id,
        ]);
    }

    /**
     * 下架物料(暂未使用)
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve (int $id) {
        return self::getClass()->unshelve([
            "id" => $id,
        ]);
    }

    /**
     * 上架sku(暂未使用)
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shelveSku (int $skuId) {
        return self::getClass()->shelveSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 下架sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelveSku (int $skuId) {
        return self::getClass()->unshelveSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 删除sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function removeSku (int $skuId) {
        return self::getClass()->removeSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 恢复sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function recoverSku (int $skuId) {
        return self::getClass()->recoverSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 批量上架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function batchShelve (array $ids) {
        return self::getClass()->batchShelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUnshelve (array $ids) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改物料信息
     *
     * @param  array $data 物料信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate (array $data) {
        return self::getClass()->batchUpdate([
            "data" => $data,
        ]);
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 撤销
     *
     * @param  string $processInstanceId sku的审批id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function revoke (string $processInstanceId) {
        return self::getClass()->revoke([
            "processInstanceId" => $processInstanceId,
        ]);
    }

    /**
     * 更新主配
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  int $cycle 配发周期 [Original type uint] 
     * @support  int $adjustMax 调整上限 [Original type uint] 
     * @support  int $adjustMin 调整下限 [Original type uint] 
     * @support  array $safetyCount 安全库存 
     * @support  array $skuInfo sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMain (int $id) {
        return self::getClass()->updateMain([
            "id" => $id,
        ]);
    }

    /**
     * 批量更新主配
     *
     * @param  array $data 主配信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdateMain (array $data) {
        return self::getClass()->batchUpdateMain([
            "data" => $data,
        ]);
    }

    /**
     * 钉钉审批回调
     *
     * @throws  \Exception
     * @return  string
     */
    public static function callbackDingProcess () {
        return self::getClass()->callbackDingProcess();
    }

    /**
     * 同步物料skuId
     *
     * @param  int $skuId sku id [Original type uint] [ require true ]
     * @param  int $nsId ns id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function syncMaterialSkuId (int $skuId, int $nsId = 0) {
        return self::getClass()->syncMaterialSkuId([
            "skuId" => $skuId,
            "nsId" => $nsId,
        ]);
    }

    /**
     * getMaterialSkus
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialSkus () {
        return self::getClass()->getMaterialSkus();
    }

    /**
     * 获取物料列表(根据门店属性查询)
     *
     * @support  array $categoryIds 分类id数组 
     * @support  string $name 物料名称 
     * @support  string $storeType 门店类型 
     * @support  int $isMain 是否主配1是0否 [Original type uint] 
     * @support  string $status sku状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterialList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMaterialList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getMaterial
     *
     * @param  string $code 物料编码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMaterial (string $code) {
        return self::getClass()->getMaterial([
            "code" => $code,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}