<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method importByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method batchSendByParams(array $params)
 * @method updateByParams(array $params)
 * @method closeByParams(array $params)
 */
class PurchaseShipNotice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  int $noticeId 发货通知单id [Original type uint] 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  string $shipBy 发货方 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  string $status 状态 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $noticeId 发货通知单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $noticeId) {
        return self::getClass()->detail([
            "noticeId" => $noticeId,
        ]);
    }

    /**
     * 导入
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function import () {
        return self::getClass()->import();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 批量发运
     *
     * @param  array $noticeIds 发货通知单ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchSend (array $noticeIds) {
        return self::getClass()->batchSend([
            "noticeIds" => $noticeIds,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $noticeItemId 发货通知单明细id [Original type uint] [ require true ]
     * @param  string $trackingNumber 本次发运单号 [ require true ]
     * @param  int $shipCount 本次发运数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $noticeItemId, string $trackingNumber, int $shipCount) {
        return self::getClass()->update([
            "noticeItemId" => $noticeItemId,
            "trackingNumber" => $trackingNumber,
            "shipCount" => $shipCount,
        ]);
    }

    /**
     * 关闭
     *
     * @param  int $noticeItemId 发货通知单明细id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function close (int $noticeItemId) {
        return self::getClass()->close([
            "noticeItemId" => $noticeItemId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseShipNotice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}