<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method updateByParams(array $params)
 */
class PurchaseDue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 列表
     *
     * @support  int $dueId 应付款单id [Original type uint] 
     * @support  string $createdAtStart 创建开始时间 
     * @support  string $createdAtEnd 创建结束时间 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @support  int $createBy 创建人工号 [Original type uint] 
     * @support  int $status 状态 [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 详情
     *
     * @param  int $dueId 预付款单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $dueId) {
        return self::getClass()->detail([
            "dueId" => $dueId,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $dueId 预付款单id [Original type uint] [ require true ]
     * @param  string $cardNumber 收款账户 [ require true ]
     * @param  string $invoiceNumber 发票号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $dueId, string $cardNumber, string $invoiceNumber) {
        return self::getClass()->update([
            "dueId" => $dueId,
            "cardNumber" => $cardNumber,
            "invoiceNumber" => $invoiceNumber,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'PurchaseDue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'PurchaseDue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}