<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSupplyChainStaffsByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateMaterialSkuByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method shelveSkuByParams(array $params)
 * @method unshelveSkuByParams(array $params)
 * @method batchShelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method revokeByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取采购员列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSupplyChainStaffs () {
        return self::getClass()->getSupplyChainStaffs();
    }

    /**
     * 创建物料
     *
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  bool $isStockTaking 是否盘点 
     * @support  bool $isFixedAsset 是否资产 
     * @support  string $fixedAssetType 资产类型 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeType 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  bool $isStockTaking 是否盘点 
     * @support  bool $isFixedAsset 是否资产 
     * @support  string $fixedAssetType 资产类型 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 更新sku信息
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @param  array $skus sku信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMaterialSku (int $id, array $skus) {
        return self::getClass()->updateMaterialSku([
            "id" => $id,
            "skus" => $skus,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据物料id获取sku信息
     *
     * @param  int $materialId 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialId (int $materialId) {
        return self::getClass()->getSkusByMaterialId([
            "materialId" => $materialId,
        ]);
    }

    /**
     * 上架物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shelve (int $id) {
        return self::getClass()->shelve([
            "id" => $id,
        ]);
    }

    /**
     * 下架物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve (int $id) {
        return self::getClass()->unshelve([
            "id" => $id,
        ]);
    }

    /**
     * 上架sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shelveSku (int $skuId) {
        return self::getClass()->shelveSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 下架sku
     *
     * @param  int $skuId skuId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelveSku (int $skuId) {
        return self::getClass()->unshelveSku([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 批量上架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchShelve (array $ids) {
        return self::getClass()->batchShelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架物料
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUnshelve (array $ids) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改物料信息
     *
     * @support  array $data 物料信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 撤销
     *
     * @support  int $id 物料id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function revoke () {
        return self::getClass()->revoke();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}