<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBrandsByParams(array $params)
 * @method getCategoriesByParams(array $params)
 * @method getUnitsByParams(array $params)
 * @method getSuppliersByParams(array $params)
 * @method getTaxesByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkusByMaterialIdByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method batchShelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method revokeByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取品牌s
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBrands (string $name = '') {
        return self::getClass()->getBrands([
            "name" => $name,
        ]);
    }

    /**
     * 获取分类s
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategories (string $name = '') {
        return self::getClass()->getCategories([
            "name" => $name,
        ]);
    }

    /**
     * 获取单位s
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUnits (string $name = '') {
        return self::getClass()->getUnits([
            "name" => $name,
        ]);
    }

    /**
     * 获取供应商s
     *
     * @param  string $name 名称 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuppliers (string $name = '') {
        return self::getClass()->getSuppliers([
            "name" => $name,
        ]);
    }

    /**
     * 获取税码s
     *
     * @param  string $desc 描述 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTaxes (string $desc = '') {
        return self::getClass()->getTaxes([
            "desc" => $desc,
        ]);
    }

    /**
     * 创建物料
     *
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  bool $isStockTaking 是否盘点 
     * @support  bool $isFixedAsset 是否资产 
     * @support  string $fixedAssetType 资产类型 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新物料
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @support  string $code 编码 
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeType 门店类型 
     * @support  int $brandId 品牌id [Original type uint] 
     * @support  string $deliveryType 发货方式 
     * @support  bool $isStockTaking 是否盘点 
     * @support  bool $isFixedAsset 是否资产 
     * @support  string $fixedAssetType 资产类型 
     * @support  array $skus sku信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取物料列表
     *
     * @support  string $name 名称 
     * @support  int $categoryId 分类id [Original type uint] 
     * @support  array $storeTypes 门店类型 
     * @support  int $supplierId 供应商id [Original type uint] 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页记录数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 10) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取物料详情
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 根据物料id获取sku信息
     *
     * @support  int $id 物料id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkusByMaterialId () {
        return self::getClass()->getSkusByMaterialId();
    }

    /**
     * 上架
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function shelve (int $id) {
        return self::getClass()->shelve([
            "id" => $id,
        ]);
    }

    /**
     * 下架
     *
     * @param  int $id 物料id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve (int $id) {
        return self::getClass()->unshelve([
            "id" => $id,
        ]);
    }

    /**
     * 批量上架
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchShelve (array $ids) {
        return self::getClass()->batchShelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量下架
     *
     * @param  array $ids 物料ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUnshelve (array $ids) {
        return self::getClass()->batchUnshelve([
            "ids" => $ids,
        ]);
    }

    /**
     * 批量修改物料信息
     *
     * @support  array $data 物料信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * 撤销
     *
     * @support  int $id 物料id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function revoke () {
        return self::getClass()->revoke();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}