<?php
namespace Mainto\Bridge\Invokes\ProjectSupplyChain;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBrandsByParams(array $params)
 * @method getCategoriesByParams(array $params)
 * @method getUnitsByParams(array $params)
 * @method getSuppliersByParams(array $params)
 * @method getTaxCodesByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method listByParams(array $params)
 * @method detailByParams(array $params)
 * @method getSkuByMaterialIdByParams(array $params)
 * @method shelveByParams(array $params)
 * @method unshelveByParams(array $params)
 * @method batchShelveByParams(array $params)
 * @method batchUnshelveByParams(array $params)
 * @method batchUpdateByParams(array $params)
 * @method newTaskByParams(array $params)
 * @method revokeByParams(array $params)
 */
class Material {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getBrands
     *
     * @param  string $name name [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getBrands (string $name = '') {
        return self::getClass()->getBrands([
            "name" => $name,
        ]);
    }

    /**
     * getCategories
     *
     * @param  string $name name [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCategories (string $name = '') {
        return self::getClass()->getCategories([
            "name" => $name,
        ]);
    }

    /**
     * getUnits
     *
     * @param  string $name name [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUnits (string $name = '') {
        return self::getClass()->getUnits([
            "name" => $name,
        ]);
    }

    /**
     * getSuppliers
     *
     * @param  string $name name [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSuppliers (string $name = '') {
        return self::getClass()->getSuppliers([
            "name" => $name,
        ]);
    }

    /**
     * getTaxCodes
     *
     * @param  string $desc desc [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTaxCodes (string $desc = '') {
        return self::getClass()->getTaxCodes([
            "desc" => $desc,
        ]);
    }

    /**
     * create
     *
     * @support  string $code code 
     * @support  string $name name 
     * @support  int $categoryId categoryId [Original type uint] 
     * @support  array $storeType storeType 
     * @support  int $brandId brandId [Original type uint] 
     * @support  string $deliveryType deliveryType 
     * @support  bool $isStockTaking isStockTaking 
     * @support  bool $isFixedAsset isFixedAsset 
     * @support  string $fixedAssetType fixedAssetType 
     * @support  array $skus skus 
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * update
     *
     * @support  int $id id [Original type uint] 
     * @support  string $code code 
     * @support  string $name name 
     * @support  int $categoryId categoryId [Original type uint] 
     * @support  array $storeType storeType 
     * @support  int $brandId brandId [Original type uint] 
     * @support  string $deliveryType deliveryType 
     * @support  bool $isStockTaking isStockTaking 
     * @support  bool $isFixedAsset isFixedAsset 
     * @support  string $fixedAssetType fixedAssetType 
     * @support  array $skus skus 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * list
     *
     * @support  string $name name 
     * @support  int $categoryId categoryId [Original type uint] 
     * @support  array $storeType storeType 
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * detail
     *
     * @support  int $id material id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function detail () {
        return self::getClass()->detail();
    }

    /**
     * getSkuByMaterialId
     *
     * @support  int $id material id [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getSkuByMaterialId () {
        return self::getClass()->getSkuByMaterialId();
    }

    /**
     * shelve
     *
     * @support  int $id material id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function shelve () {
        return self::getClass()->shelve();
    }

    /**
     * unshelve
     *
     * @support  int $id material id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function unshelve () {
        return self::getClass()->unshelve();
    }

    /**
     * batchShelve
     *
     * @support  array $ids material ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchShelve () {
        return self::getClass()->batchShelve();
    }

    /**
     * batchUnshelve
     *
     * @support  array $ids material ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUnshelve () {
        return self::getClass()->batchUnshelve();
    }

    /**
     * batchUpdate
     *
     * @support  array $data material ids 
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchUpdate () {
        return self::getClass()->batchUpdate();
    }

    /**
     * 新增导出任务
     *
     * @support  string $template_id 模板id [ require true ]
     * @support  array $params 参数 
     * @throws  \Exception
     * @return  string
     */
    public static function newTask () {
        return self::getClass()->newTask();
    }

    /**
     * revoke
     *
     * @support  int $id material id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function revoke () {
        return self::getClass()->revoke();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectSupplyChain', 'Material');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectSupplyChain', 'Material');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}