<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method submitByParams(array $params)
 * @method getListByParams(array $params)
 * @method cancelByParams(array $params)
 * @method detailByParams(array $params)
 * @method confirmByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 提交订单
     *
     * @param  array $data 订单项数据 [ require true ]
     * @support  int $couponId 优惠券id [ require false ]
     * @support  float $discountFee 优惠金额 [ require false ]
     * @param  string $from 来源 [ require false ]
     * @support  bool $agreement 用户协议 [ require false ]
     * @support  bool $graduateAgreement 高校用户协议 [ require false ]
     * @param  string $token 用户token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submit (array $data, string $from = 'user', string $token = null) {
        return self::getClass()->submit([
            "data" => $data,
            "from" => $from,
            "token" => $token,
        ]);
    }

    /**
     * 我的订单列表
     *
     * @param  string $state 订单状态 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (string $state = null, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getList([
            "state" => $state,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 取消订单
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancel (int $id) {
        return self::getClass()->cancel([
            "id" => $id,
        ]);
    }

    /**
     * 获取订单详情
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 订单确认
     *
     * @param  int $id 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirm (int $id) {
        return self::getClass()->confirm([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}