<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method exportByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method closeByParams(array $params)
 * @method editOrderRetouchClaimByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单列表
     *
     * @support  mixed $cond  require false
     * @support  array $cond 条件 require false
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 导出订单s
     *
     * @support  mixed $cond  require false
     * @throws  \Exception
     * @return  array
     */
    public static function export () {
        return self::getClass()->export();
    }

    /**
     * 订单详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 关闭订单
     *
     * @param  int $id id [ require true ]
     * @param  string $reason reason [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function close (int $id, string $reason) {
        return self::getClass()->close([
            "id" => $id,
            "reason" => $reason,
        ]);
    }

    /**
     * 修改订单修图要求
     *
     * @param  int $id id [ require true ]
     * @param  array $retouchClaim 修片要求 [ require true ]
     * @param  string $note 备注 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editOrderRetouchClaim (int $id, array $retouchClaim, string $note = '') {
        return self::getClass()->editOrderRetouchClaim([
            "id" => $id,
            "retouchClaim" => $retouchClaim,
            "note" => $note,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}