<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponDetailByParams(array $params)
 * @method getCouponBatchListByParams(array $params)
 * @method getCouponBatchDetailByParams(array $params)
 * @method getCouponBatchCodeUseListByParams(array $params)
 * @method addCouponBatchByParams(array $params)
 * @method voidCouponBatchByParams(array $params)
 * @method voidCouponCodeByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询优惠券详情
     *
     * @param  string $code 券码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCouponDetail (string $code) {
        return self::getClass()->getCouponDetail([
            "code" => $code,
        ]);
    }

    /**
     * 查询优惠券批次列表
     *
     * @support  mixed $cond  require false
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponBatchList () {
        return self::getClass()->getCouponBatchList();
    }

    /**
     * 批次详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponBatchDetail (int $id) {
        return self::getClass()->getCouponBatchDetail([
            "id" => $id,
        ]);
    }

    /**
     * 获取券码批次使用情况列表
     *
     * @support  mixed $cond [] require false
     * @support  int $page page require false
     * @support  int $pageSize pageSize require false
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponBatchCodeUseList () {
        return self::getClass()->getCouponBatchCodeUseList();
    }

    /**
     * 新增券码批次
     *
     * @support  string $title 标题 [ require true ]
     * @support  string $type 类型 require false
     * @support  int $total 总发行量 require false
     * @support  float $value 折扣/立减金额 [ require true ]
     * @support  mixed $limit limit [ require true ]
     * @support  string $note 备注 require false
     * @support  string $dateType 生效规则 require false
     * @support  int $expireDay 领取后几天有效 require false
     * @support  string $stopAt 结束生效时间 require false
     * @support  string $startAt 开始生效时间 require false
     * @throws  \Exception
     * @return  int
     */
    public static function addCouponBatch () {
        return self::getClass()->addCouponBatch();
    }

    /**
     * 优惠券批次作废
     *
     * @support  int $id 批次id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function voidCouponBatch () {
        return self::getClass()->voidCouponBatch();
    }

    /**
     * 优惠券券码作废
     *
     * @support  int $batchId 批次id [ require true ]
     * @support  string $code 券码code [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function voidCouponCode () {
        return self::getClass()->voidCouponCode();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Marketing\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Marketing\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}