<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array $params)
 * @method batchDeleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method batchGetByParams(array $params)
 */
class Negative {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * [不需要登录]
     *
     * @param  string $outSn 外部订单号 [ require true ]
     * @param  int $page page [ require true ]
     * @param  int $pageSize pageSize [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (string $outSn, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getList([
            "outSn" => $outSn,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 批量删除
     *
     * @param  array $ids 底片ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchDelete (array $ids) {
        return self::getClass()->batchDelete([
            "ids" => $ids,
        ]);
    }

    /**
     * 底片详情
     *
     * @param  int $id 底片id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail (int $id) {
        return self::getClass()->detail([
            "id" => $id,
        ]);
    }

    /**
     * 批量获取
     *
     * @param  array $ids 底片ids [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchGet (array $ids) {
        return self::getClass()->batchGet([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\Negative');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\Negative');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}