<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin\Trading;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addWithConfigByParams(array $params)
 * @method editWithConfigByParams(array $params)
 * @method infoByParams(array $params)
 * @method getListByParams(array $params)
 * @method sortByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建产品并添加各种配置-v1.8
     *
     * @support  string $name 产品名称, 长度最高为10个字符 require false
     * @support  string $description 产品简介, 长度最高为20个字符 require false
     * @support  string $thumbnailPath 缩略图 [ require true ]
     * @support  int $handle_account 是否联系客服 [ require true ]
     * @support  float $price 产品展示价格 require false
     * @support  string $sharePath 分享图 [ require true ]
     * @support  string $coverPath 头图/封面图地址 [ require true ]
     * @support  string $information 详情介绍 [ require true ]
     * @support  string $startAt 上线时间 require false
     * @support  string $endAt 下线时间 require false
     * @support  array $productSkus 价格配置 require false
     * @support  array $skus 规格配置 require false
     * @support  mixed $extend 透传参数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWithConfig () {
        return self::getClass()->addWithConfig();
    }

    /**
     * 编辑产品-v1.8
     *
     * @support  int $id 产品id [ require true ]
     * @support  string $name 产品名称, 长度最高为10个字符 require false
     * @support  string $description 产品简介, 长度最高为20个字符 require false
     * @support  int $handle_account 是否联系客服 require false
     * @support  float $price 产品展示价格 require false
     * @support  string $thumbnailPath 缩略图 require false
     * @support  string $sharePath 分享图 require false
     * @support  string $coverPath 头图/封面图地址 require false
     * @support  string $information 详情介绍 require false
     * @support  string $startAt 上线时间 require false
     * @support  string $endAt 下线时间 require false
     * @support  string $state 立即上线/下线 require false
     * @support  array $productSkus 价格配置 require false
     * @support  array $skus 规格配置 require false
     * @support  array $extend 修图要求 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWithConfig () {
        return self::getClass()->editWithConfig();
    }

    /**
     * 获取产品信息-v1.8
     *
     * @param  int $id 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品列表-v1.8
     *
     * @support  mixed $cond  require false
     * @support  array $cond 查询条件 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 对产品进行排序-v1.8
     *
     * @param  array $productWeights 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sort (array $productWeights) {
        return self::getClass()->sort([
            "productWeights" => $productWeights,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Trading\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Trading\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}