<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPaySignByParams(array $params)
 * @method notifyByParams(array $params)
 */
class Payment {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取支付票据
     *
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  string $token 用户token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySign (int $orderId, string $token = NULL) {
        return self::getClass()->getPaySign([
            "orderId" => $orderId,
            "token" => $token,
        ]);
    }

    /**
     * 支付回调
     *
     * @support  string $data 交易返回数据 [ require true ]
     * @support  string $sign 签名 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function notify () {
        return self::getClass()->notify();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\Payment');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\Payment');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}