<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Api;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getProductSkuListByParams(array $params)
 * @method getProductDetailByParams(array $params)
 */
class ProductSku {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 取所有产品服务表
     *
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @param  mixed $conds 查询条件 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductSkuList ($conds = [], int $page = 1, int $pageSize = 10) {
        return self::getClass()->getProductSkuList([
            "conds" => $conds,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getProductDetail
     *
     * @param  int $id 修修兽产品服务id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getProductDetail (int $id) {
        return self::getClass()->getProductDetail([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Api\ProductSku');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Api\ProductSku');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}