<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addProductByParams(array $params)
 * @method addSkuByParams(array $params)
 * @method addProductSkuByParams(array $params)
 * @method addRequireSetByParams(array $params)
 * @method addProductSkuRequireSetByParams(array $params)
 * @method initRandomSequenceByParams(array $params)
 * @method paidOrderByParams(array $params)
 * @method getSmsCodeWithoutCaptionByParams(array $params)
 * @method clearCouponCodesCacheByParams(array $params)
 * @method clearActivityCacheByParams(array $params)
 * @method eventOrderConfirmPaidByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [ require false ]
     * @support  string $name name [ require false ]
     * @support  string $coverPath cover_path [ require false ]
     * @support  string $thumbnailPath thumbnailPath [ require false ]
     * @support  string $sharePath sharePath [ require false ]
     * @support  string $description description [ require false ]
     * @support  string $information information [ require false ]
     * @support  int $weight 权重 [ require false ]
     * @support  bool $hidden 是否隐藏 [ require false ]
     * @support  bool $handleAccount 联系客服下单 [ require false ]
     * @support  array $extend 透传参数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProduct () {
        return self::getClass()->addProduct([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [ require false ]
     * @support  string $name name [ require false ]
     * @support  string $imgPath 演示图 [ require false ]
     * @support  string $type type [ require false ]
     * @support  int $parentId parentId [ require false ]
     * @support  string $description description [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addSku () {
        return self::getClass()->addSku([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [ require false ]
     * @support  int $productId productId [ require false ]
     * @support  array $skus skus [ require false ]
     * @support  string $name name [ require false ]
     * @support  int $cloudProductId cloud_product_id [ require false ]
     * @support  float $price price [ require false ]
     * @support  array $priceExtend priceExtend [ require false ]
     * @support  string $imgPath imgPath [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductSku () {
        return self::getClass()->addProductSku([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [ require false ]
     * @support  string $name name [ require false ]
     * @support  string $value 标识符 [ require false ]
     * @support  array $sets 配置数组 [ require false ]
     * @support  string $type type [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addRequireSet () {
        return self::getClass()->addRequireSet([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  int $id id [ require false ]
     * @support  int $productSkuId productSkuId [ require true ]
     * @support  int $productRequireSetId 产品要求set id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addProductSkuRequireSet () {
        return self::getClass()->addProductSkuRequireSet([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function paidOrder () {
        return self::getClass()->paidOrder([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @support  string $type 发送类型 [ require true ]
     * @support  string $phone 手机号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSmsCodeWithoutCaption () {
        return self::getClass()->getSmsCodeWithoutCaption([
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @param  string $id activityId [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearCouponCodesCache (string $id) {
        return self::getClass()->clearCouponCodesCache([
            "id" => $id,
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @param  string $code 活动代码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function clearActivityCache (string $code) {
        return self::getClass()->clearActivityCache([
            "code" => $code,
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @param  string $orderNum orderNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function eventOrderConfirmPaid (string $orderNum) {
        return self::getClass()->eventOrderConfirmPaid([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}