<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method getListByParams(array $params)
 * @method editByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method offlineByParams(array $params)
 * @method delByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成活动
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $beginTime 活动开始时间 [ require true ]
     * @support  string $endTime 活动结束时间 [ require true ]
     * @support  mixed $shareConfig 分享配置 [ require true ]
     * @support  mixed $styleConfig 风格配置配置 [ require true ]
     * @support  mixed $couponConfig 配置 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function add () {
        return self::getClass()->add([
        ]);
    }

    /**
     * 获取活动列表
     *
     * @param  mixed $cond  [ require false ]
     * @param  array $cond 查询条件 [ require false ]
     * @param  int $page page [ require false ]
     * @param  int $pageSize pageSize [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getList (array $cond = [], int $page = 1, int $pageSize = 20) {
        return self::getClass()->getList([
            "cond" => $cond,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 活动编辑
     *
     * @param  int $id id [ require true ]
     * @support  string $name 名称 [ require false ]
     * @support  string $beginTime 活动开始时间 [ require false ]
     * @support  string $endTime 活动结束时间 [ require false ]
     * @support  mixed $shareConfig 分享配置 [ require false ]
     * @support  mixed $styleConfig 风格配置 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * 获取活动详情
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 活动下线
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 活动删除
     *
     * @param  int $id id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function del (int $id) {
        return self::getClass()->del([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Marketing\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Marketing\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}