<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Bpo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method autoDeletePhotoByParams(array $params)
 * @method autoDeleteQiniuPhotoByParams(array $params)
 * @method autoSendWxPushByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 确认批次后12小时删除未下单照片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDeletePhoto () {
        return self::getClass()->autoDeletePhoto();
    }

    /**
     * 确认批次后180天自动删除七牛云资源
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDeleteQiniuPhoto () {
        return self::getClass()->autoDeleteQiniuPhoto();
    }

    /**
     * 确认批次后12小时删除未下单照片
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoSendWxPush () {
        return self::getClass()->autoSendWxPush();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Bpo\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Bpo\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}