<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Bpo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByParams(array $params)
 * @method getSelfInfoByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 登陆
     *
     * @param  string $account account [ require true ]
     * @param  string $password password [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function login (string $account, string $password) {
        return self::getClass()->login([
            "account" => $account,
            "password" => $password,
        ]);
    }

    /**
     * 获取个人信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfInfo () {
        return self::getClass()->getSelfInfo();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Bpo\Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Bpo\Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}