<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\SmallProgram\My;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouponListByParams(array $params)
 * @method receiveCouponByParams(array $params)
 * @method exchangeCouponByParams(array $params)
 * @method getUnclaimedCouponsByParams(array $params)
 * @method receiveUnclaimedCouponsByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的优惠券列表
     *
     * @param  array $states 订单状态s [ require true ]
     * @support  int $page page [Original type uint] 
     * @support  int $pageSize pageSize [Original type uint] 
     * @throws  \Exception
     * @return  array
     */
    public static function getCouponList (array $states) {
        return self::getClass()->getCouponList([
            "states" => $states,
        ]);
    }

    /**
     * 领取优惠券
     *
     * @param  string $activityId 活动id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $verificationCode 验证码 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveCoupon (string $activityId, string $phone, string $verificationCode) {
        return self::getClass()->receiveCoupon([
            "activityId" => $activityId,
            "phone" => $phone,
            "verificationCode" => $verificationCode,
        ]);
    }

    /**
     * 兑换优惠券
     *
     * @param  string $code 优惠券编码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exchangeCoupon (string $code) {
        return self::getClass()->exchangeCoupon([
            "code" => $code,
        ]);
    }

    /**
     * 获取待领取券
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUnclaimedCoupons () {
        return self::getClass()->getUnclaimedCoupons();
    }

    /**
     * 获取待领取券
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveUnclaimedCoupons () {
        return self::getClass()->receiveUnclaimedCoupons();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'SmallProgram\My\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'SmallProgram\My\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}