<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Bpo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method preCreateByParams(array $params)
 * @method addPhotoToRecordByParams(array $params)
 * @method confirmRecordByParams(array $params)
 * @method getRecordListByParams(array $params)
 * @method getRecordWithPhotosByParams(array $params)
 */
class Record {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预创建上传批次
     *
     * @param  int $year 年份 [ require true ]
     * @param  array $school school [ require true ]
     * @support  string $school.number 院校编号 [ require true ]
     * @support  string $school.name 学校名 [ require true ]
     * @param  array $extend 拓展字段 [ require true ]
     * @support  int $extend.total_people 总人数 [ require true ]
     * @support  int $extend.match_people 匹配人数 [ require true ]
     * @param  array $idCards 身份证s [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function preCreate (int $year, array $school, array $extend, array $idCards) {
        return self::getClass()->preCreate([
            "year" => $year,
            "school" => $school,
            "extend" => $extend,
            "idCards" => $idCards,
        ]);
    }

    /**
     * 往批次添加照片
     *
     * @param  int $recordId 记录id [ require true ]
     * @param  array $photoDatas 照片数据s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotoToRecord (int $recordId, array $photoDatas) {
        return self::getClass()->addPhotoToRecord([
            "recordId" => $recordId,
            "photoDatas" => $photoDatas,
        ]);
    }

    /**
     * 确认批次
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmRecord (int $recordId) {
        return self::getClass()->confirmRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 获取上传记录
     *
     * @param  array $cond 确认时间 [ require true ]
     * @support  array $cond.confirmAtRanges 确认时间 
     * @support  string $cond.schoolNameLike 学校名称 like 
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordList (array $cond) {
        return self::getClass()->getRecordList([
            "cond" => $cond,
        ]);
    }

    /**
     * 获取上传记录以及对应的所有照片
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordWithPhotos (int $recordId) {
        return self::getClass()->getRecordWithPhotos([
            "recordId" => $recordId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Bpo\Record');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Bpo\Record');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}