<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Bpo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addPhotographerByParams(array $params)
 * @method sendWxPushByParams(array $params)
 */
class Temp {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @param  string $account 账号 [ require true ]
     * @param  string $name 名称 [ require true ]
     * @param  string $secret secret [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addPhotographer (string $account, string $name, string $secret) {
        return self::getClass()->addPhotographer([
            "account" => $account,
            "name" => $name,
            "secret" => $secret,
        ]);
    }

    /**
     * 目前依赖云端产品审核　编辑权限
     *
     * @param  int $userId userId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function sendWxPush (int $userId) {
        return self::getClass()->sendWxPush([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Bpo\Temp');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Bpo\Temp');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}