<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Bpo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method preCreateByParams(array $params)
 * @method addPhotoToRecordByParams(array $params)
 * @method confirmRecordByParams(array $params)
 * @method getRecordListByParams(array $params)
 * @method getRecordWithPhotosByParams(array $params)
 */
class Record {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 预创建上传批次
     *
     * @support  int $year 年份 [ require true ]
     * @support  array $school school [ require true ]
     * @support  string $school.number 院校编号 [ require true ]
     * @support  string $school.name 学校名 [ require true ]
     * @support  array $extend 拓展字段 [ require true ]
     * @support  int $extend.total_people 总人数 [ require true ]
     * @support  int $extend.match_people 匹配人数 [ require true ]
     * @support  array $idCards 身份证s [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function preCreate () {
        return self::getClass()->preCreate();
    }

    /**
     * 往批次添加照片
     *
     * @support  int $recordId 记录id [ require true ]
     * @support  array $photoDatas 照片数据s [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addPhotoToRecord () {
        return self::getClass()->addPhotoToRecord();
    }

    /**
     * 确认批次
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmRecord (int $recordId) {
        return self::getClass()->confirmRecord([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 获取上传记录
     *
     * @support  array $confirmAtRanges 确认时间 
     * @support  string $schoolName 学校名称 like 
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordList () {
        return self::getClass()->getRecordList();
    }

    /**
     * 获取上传记录以及对应的所有照片
     *
     * @support  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRecordWithPhotos () {
        return self::getClass()->getRecordWithPhotos();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Bpo\Record');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Bpo\Record');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}