<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookStreamStateChangedByParams(array $params)
 * @method hookStreamPassedByParams(array $params)
 * @method hookNegativeSeedByParams(array $params)
 * @method hookSecondRetouchUpdatePhotoByParams(array $params)
 * @method hookSecondRetouchOrderAdjustingByParams(array $params)
 * @method hookSecondRetouchWatchRecordSatisfiedByParams(array $params)
 * @method hookWatchOnlinePhotoSatisfiedByParams(array $params)
 * @method hookHMTMemberActiveChangeByParams(array $params)
 * @method hookHMTMemberChangeByParams(array $params)
 * @method hookCloudProductReviewPassByParams(array $params)
 * @method hookCloudProductReviewRefuseByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook 云端流水状态变更
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  int $retoucher_id 修片师id [Original type uint] 
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamStateChanged () {
        return self::getClass()->hookStreamStateChanged();
    }

    /**
     * hook 云端流水审核通过
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPassed () {
        return self::getClass()->hookStreamPassed();
    }

    /**
     * hook 底片消息通知已发送
     *
     * @param  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookNegativeSeed (array $photos) {
        return self::getClass()->hookNegativeSeed([
            "photos" => $photos,
        ]);
    }

    /**
     * hook 看片师已更新照片
     *
     * @support  string $orderNum orderNum [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @support  int $num 照片数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchUpdatePhoto () {
        return self::getClass()->hookSecondRetouchUpdatePhoto();
    }

    /**
     * hook 在线看片接单 订单调整中
     *
     * @support  string $outSideNo orderNum [ require true ]
     * @support  int $watcherId 看片师工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchOrderAdjusting () {
        return self::getClass()->hookSecondRetouchOrderAdjusting();
    }

    /**
     * hook 顾客看片单已完成
     *
     * @support  string $outsideNo orderNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchWatchRecordSatisfied () {
        return self::getClass()->hookSecondRetouchWatchRecordSatisfied();
    }

    /**
     * hook 在线看片2.0 顾客满意照片
     *
     * @param  int $pictureOnlinePhotoId 在线看片的照片id [Original type uint] [ require true ]
     * @param  string $finalPath 在线看片－最终满意片 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookWatchOnlinePhotoSatisfied (int $pictureOnlinePhotoId, string $finalPath) {
        return self::getClass()->hookWatchOnlinePhotoSatisfied([
            "pictureOnlinePhotoId" => $pictureOnlinePhotoId,
            "finalPath" => $finalPath,
        ]);
    }

    /**
     * hook 海马体会员等级激活
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $currentLevel 当前等级 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookHMTMemberActiveChange () {
        return self::getClass()->hookHMTMemberActiveChange();
    }

    /**
     * hook 海马体会员等级变动
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $currentLevel 当前等级 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookHMTMemberChange () {
        return self::getClass()->hookHMTMemberChange();
    }

    /**
     * hookCloudProductReviewPass
     *
     * @param  int $cloudProductId 云端产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudProductReviewPass (int $cloudProductId) {
        return self::getClass()->hookCloudProductReviewPass([
            "cloudProductId" => $cloudProductId,
        ]);
    }

    /**
     * hook 云端产品审核拒绝
     *
     * @param  int $cloudProductId 云端产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookCloudProductReviewRefuse (int $cloudProductId) {
        return self::getClass()->hookCloudProductReviewRefuse([
            "cloudProductId" => $cloudProductId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}