<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin\Trading;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addWithConfigByParams(array $params)
 * @method editWithConfigByParams(array $params)
 * @method infoByParams(array $params)
 * @method getListByParams(array $params)
 * @method sortByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 新建产品并添加各种配置-v1.8
     *
     * @support  string $name 产品名称, 长度最高为10个字符 [ require true ]
     * @support  string $description 产品简介, 长度最高为20个字符 [ require true ]
     * @support  string $thumbnailPath 缩略图 [ require true ]
     * @support  int $handle_account 是否联系客服 [Original type uint] [ require true ]
     * @support  float $price 产品展示价格 [Original type unsignedDouble] 
     * @support  string $sharePath 分享图 [ require true ]
     * @support  string $coverPath 头图/封面图地址 [ require true ]
     * @support  string $information 详情介绍 [ require true ]
     * @support  string $startAt 上线时间 [ require true ]
     * @support  string $endAt 下线时间 
     * @support  array $productSkus 价格配置 
     * @support  array $skus 规格配置 
     * @support  array $extend 透传参数 [ require true ]
     * @support  string $extend.cloud_retouch_require 修图要求 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addWithConfig () {
        return self::getClass()->addWithConfig();
    }

    /**
     * 编辑产品-v1.8
     *
     * @support  int $id 产品id [Original type uint] [ require true ]
     * @support  string $name 产品名称, 长度最高为10个字符 
     * @support  string $description 产品简介, 长度最高为20个字符 
     * @support  int $handle_account 是否联系客服 [Original type uint] 
     * @support  float $price 产品展示价格 [Original type unsignedDouble] 
     * @support  string $thumbnailPath 缩略图 
     * @support  string $sharePath 分享图 
     * @support  string $coverPath 头图/封面图地址 
     * @support  string $information 详情介绍 
     * @support  string $startAt 上线时间 
     * @support  string $endAt 下线时间 
     * @support  array $productSkus 价格配置 
     * @support  array $skus 规格配置 
     * @support  array $extend 修图要求 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWithConfig () {
        return self::getClass()->editWithConfig();
    }

    /**
     * 获取产品信息-v1.8
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 获取产品列表-v1.8
     *
     * @support  array $cond.stateIn 产品状态, in:online,offline,wait 
     * @support  array $cond 查询条件 
     * @throws  \Exception
     * @return  array
     */
    public static function getList () {
        return self::getClass()->getList();
    }

    /**
     * 对产品进行排序-v1.8
     *
     * @param  array $productWeights 产品id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sort (array $productWeights) {
        return self::getClass()->sort([
            "productWeights" => $productWeights,
        ]);
    }

    /**
     * 立即上线-v1.8
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 立即下线-v1.8
     *
     * @param  int $id 产品id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Trading\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Trading\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}