<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin\Marketing;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addByParams(array $params)
 * @method getListByParams(array $params)
 * @method editByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method offlineByParams(array $params)
 * @method delByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成活动
     *
     * @support  string $name 名称 [ require true ]
     * @support  string $beginTime 活动开始时间 [ require true ]
     * @support  string $endTime 活动结束时间 [ require true ]
     * @support  string $shareConfig.mainImg 活动分享图地址 [ require true ]
     * @support  string $shareConfig.title 活动分享标题 [ require true ]
     * @support  string $shareConfig.desc 活动分享描述 [ require true ]
     * @support  string $styleConfig.title 页面标题 [ require true ]
     * @support  string $styleConfig.headerImg 页面头图地址 [ require true ]
     * @support  string $styleConfig.bkgColor 背景色 [ require true ]
     * @support  string $styleConfig.captchaBkgColor 验证码背景色 [ require true ]
     * @support  string $styleConfig.receiveBkgColor 领取背景色 [ require true ]
     * @support  string $styleConfig.rules.* 活动说明 [ require true ]
     * @support  string $styleConfig.rulesFontColor 说明字体颜色 [ require true ]
     * @support  string $couponConfig.title 标题 [ require true ]
     * @support  string $couponConfig.type 类型 [ require true ]
     * @support  int $couponConfig.total 总发行量 [Original type uint] 
     * @support  int $couponConfig.limitCount 每人限领张数 [Original type uint] 
     * @support  float $couponConfig.value 折扣/立减金额 [Original type unsignedDouble] [ require true ]
     * @support  float $couponConfig.limit.reductionUpperLimit 活动限制.减免金额上限 [Original type unsignedDouble] 
     * @support  float $couponConfig.limit.orderMoneyLowerLimit 活动限制.订单金额下限 [Original type unsignedDouble] 
     * @support  string $couponConfig.note 备注 
     * @support  string $couponConfig.dateType 生效规则 [ require true ]
     * @support  int $couponConfig.expireDay 领取后几天有效 [Original type uint] 
     * @support  string $couponConfig.stopAt 结束生效时间 
     * @support  string $couponConfig.startAt 开始生效时间 
     * @throws  \Exception
     * @return  int
     */
    public static function add () {
        return self::getClass()->add();
    }

    /**
     * 获取活动列表
     *
     * @support  string $cond.name 查询条件-活动名称 
     * @support  string $cond.createBeginTime 查询条件-活动开始时间 
     * @support  string $cond.createEndTime 查询条件-活动结束时间 
     * @support  int $cond.status 查询条件-状态 [Original type uint] 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 活动编辑
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  string $beginTime 活动开始时间 
     * @support  string $endTime 活动结束时间 
     * @support  string $shareConfig.mainImg 活动分享图地址 
     * @support  string $shareConfig.title 活动分享标题 
     * @support  string $shareConfig.desc 活动分享描述 
     * @support  string $styleConfig.title 页面标题 
     * @support  string $styleConfig.headerImg 页面头图地址 
     * @support  string $styleConfig.bkgColor 背景色 
     * @support  string $styleConfig.captchaBkgColor 验证码背景色 
     * @support  string $styleConfig.receiveBkgColor 领取背景色 
     * @support  string $styleConfig.rules.* 活动说明 
     * @support  string $styleConfig.rulesFontColor 说明字体颜色 
     * @throws  \Exception
     * @return  mixed
     */
    public static function edit (int $id) {
        return self::getClass()->edit([
            "id" => $id,
        ]);
    }

    /**
     * 获取活动详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 活动下线
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 活动删除
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function del (int $id) {
        return self::getClass()->del([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Marketing\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Marketing\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}