<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method initRandomSequenceByParams(array $params)
 * @method closeOrderByParams(array $params)
 * @method confirmOrderByParams(array $params)
 * @method autoDeleteNegativeByParams(array $params)
 * @method autoActivityStartByParams(array $params)
 * @method autoActivityEndByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 生成第二日随机码
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function initRandomSequence () {
        return self::getClass()->initRandomSequence();
    }

    /**
     * 订单超15分钟未支付自动关闭
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeOrder () {
        return self::getClass()->closeOrder();
    }

    /**
     * 订单超15天自动确认
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmOrder () {
        return self::getClass()->confirmOrder();
    }

    /**
     * 底片发送后７天自动删除
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoDeleteNegative () {
        return self::getClass()->autoDeleteNegative();
    }

    /**
     * 每分钟自动检查活动状态是否需要开始
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoActivityStart () {
        return self::getClass()->autoActivityStart();
    }

    /**
     * 每分钟自动检查活动状态是否需要关闭
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function autoActivityEnd () {
        return self::getClass()->autoActivityEnd();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}