<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvoiceListByParams(array $params)
 * @method getCanInvoiceOrderListByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method voidInvoiceByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取发票列表
     *
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvoiceList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getInvoiceList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取可开发票订单列表
     *
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanInvoiceOrderList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getCanInvoiceOrderList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发票详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 作废
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function voidInvoice (int $id) {
        return self::getClass()->voidInvoice([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}