<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvoiceListByParams(array $params)
 * @method getCanInvoiceOrderListByParams(array $params)
 * @method getDetailByParams(array $params)
 * @method reSendByParams(array $params)
 * @method voidInvoiceByParams(array $params)
 * @method applyInvoiceByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取发票列表
     *
     * @support  string $startTime 开始时间 
     * @support  string $endTime 结束时间 
     * @support  string $status 状态 
     * @support  string $title 抬头(前缀模糊查询) 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInvoiceList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getInvoiceList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取可开发票订单列表
     *
     * @support  string $phone 用户账号 
     * @support  string $orderNum 订单号 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCanInvoiceOrderList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getCanInvoiceOrderList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 发票详情
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getDetail (int $id) {
        return self::getClass()->getDetail([
            "id" => $id,
        ]);
    }

    /**
     * 电子发票重新发送
     *
     * @param  int $invoiceId 发票id [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $email 邮箱 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function reSend (int $invoiceId, string $phone = '', string $email = '') {
        return self::getClass()->reSend([
            "invoiceId" => $invoiceId,
            "phone" => $phone,
            "email" => $email,
        ]);
    }

    /**
     * 作废
     *
     * @param  int $id id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function voidInvoice (int $id) {
        return self::getClass()->voidInvoice([
            "id" => $id,
        ]);
    }

    /**
     * 申请开具
     *
     * @support  string $invoiceType 发票类型[电子] [ require true ]
     * @support  string $type 类型[普票] [ require true ]
     * @support  string $titleType 抬头类型 [ require true ]
     * @support  string $title 抬头 [ require true ]
     * @support  string $taxNum 单位税号 
     * @support  string $content 内容 
     * @support  float $money 发票金额 [Original type double] [ require true ]
     * @support  string $receiveInfo.phone 收票信息-手机号 
     * @support  string $receiveInfo.email 收票信息－邮箱 
     * @support  string $otherInfo.address 注册地址 
     * @support  string $otherInfo.telephone 注册电话 
     * @support  string $otherInfo.bankName 开户银行 
     * @support  string $otherInfo.bankAccount 银行账号 
     * @support  array $order_nums 订单num数组 [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function applyInvoice () {
        return self::getClass()->applyInvoice();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}