<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method addOrEditRoleByParams(array $params)
 * @method getRoleListByParams(array $params)
 * @method addOrEditStaffByParams(array $params)
 * @method getStaffListByParams(array $params)
 * @method getPermissionsByParams(array $params)
 * @method getStaffPermissionByParams(array $params)
 */
class Staff {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建/编辑角色组
     *
     * @param  string $title 角色名 [ require true ]
     * @param  array $permissionIds 权限ids [ require true ]
     * @param  int $roleId 角色id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addOrEditRole (string $title, array $permissionIds, int $roleId = NULL) {
        return self::getClass()->addOrEditRole([
            "title" => $title,
            "permissionIds" => $permissionIds,
            "roleId" => $roleId,
        ]);
    }

    /**
     * 获取角色组列表
     *
     * @support  string $title 角色名 
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getRoleList (int $page = 1, int $pageSize = 20) {
        return self::getClass()->getRoleList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 创建/编辑伙伴
     *
     * @param  int $staffId 工号 [Original type uint] [ require true ]
     * @param  int $roleId 角色id [Original type uint] [ require true ]
     * @param  array $permissionIds 权限ids [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function addOrEditStaff (int $staffId, int $roleId, array $permissionIds = []) {
        return self::getClass()->addOrEditStaff([
            "staffId" => $staffId,
            "roleId" => $roleId,
            "permissionIds" => $permissionIds,
        ]);
    }

    /**
     * 获取伙伴列表
     *
     * @param  int $page page [Original type uint] [ require true ]
     * @param  int $pageSize pageSize [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffList (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getStaffList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取所有权限
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getPermissions () {
        return self::getClass()->getPermissions();
    }

    /**
     * 获取伙伴权限信息
     *
     * @param  int $staffId 伙伴工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStaffPermission (int $staffId) {
        return self::getClass()->getStaffPermission([
            "staffId" => $staffId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Staff');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Staff');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}