<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic\Admin;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method hookStreamStateChangedByParams(array $params)
 * @method hookStreamPassedByParams(array $params)
 * @method hookNegativeSeedByParams(array $params)
 * @method hookSecondRetouchUpdatePhotoByParams(array $params)
 * @method hookSecondRetouchStreamWaitAdjustByParams(array $params)
 * @method hookSecondRetouchStreamAdjustingByParams(array $params)
 * @method hookSecondRetouchStreamSatisfiedByParams(array $params)
 * @method hookSecondRetouchPhotoSatisfiedByParams(array $params)
 */
class Hook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * hook 云端流水状态变更
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  int $retoucher_id 修片师id [Original type uint] 
     * @support  string $state 状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamStateChanged () {
        return self::getClass()->hookStreamStateChanged();
    }

    /**
     * hook 云端流水审核通过
     *
     * @support  string $stream_num 云端流水号 [ require true ]
     * @support  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookStreamPassed () {
        return self::getClass()->hookStreamPassed();
    }

    /**
     * hook 底片消息通知已发送
     *
     * @param  array $photos 照片数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookNegativeSeed (array $photos) {
        return self::getClass()->hookNegativeSeed([
            "photos" => $photos,
        ]);
    }

    /**
     * hook 看片师已更新照片
     *
     * @support  string $orderNum orderNum [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @support  int $num 照片数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchUpdatePhoto () {
        return self::getClass()->hookSecondRetouchUpdatePhoto();
    }

    /**
     * hook 在线看片已同步，流水待调整
     *
     * @support  string $orderNum orderNum [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchStreamWaitAdjust () {
        return self::getClass()->hookSecondRetouchStreamWaitAdjust();
    }

    /**
     * hook 流水调整中
     *
     * @support  string $orderNum orderNum [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @support  int $retoucherNo 看片师工号 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchStreamAdjusting () {
        return self::getClass()->hookSecondRetouchStreamAdjusting();
    }

    /**
     * hook 顾客流水已满意
     *
     * @support  string $orderNum orderNum [ require true ]
     * @support  string $streamNum streamNum [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchStreamSatisfied () {
        return self::getClass()->hookSecondRetouchStreamSatisfied();
    }

    /**
     * hook 顾客满意照片
     *
     * @support  string $streamNum streamNum [ require true ]
     * @support  string $originalPath 在线看片－原片 [ require true ]
     * @support  string $satisfiedPath 在线看片－顾客满意片 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function hookSecondRetouchPhotoSatisfied () {
        return self::getClass()->hookSecondRetouchPhotoSatisfied();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Admin\Hook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}