<?php
namespace Mainto\Bridge\Invokes\ProjectShowPic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUploadTokenByParams(array $params)
 * @method getHostByParams(array $params)
 * @method getHostInitPrefixByParams(array $params)
 * @method aboutByParams(array $params)
 * @method getPhotoByParams(array $params)
 * @method eventLogByParams(array $params)
 * @method getSelfPermissionByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取七牛云上传token
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * 获取host
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getHost () {
        return self::getClass()->getHost();
    }

    /**
     * 获取hostInitPrefix
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getHostInitPrefix () {
        return self::getClass()->getHostInitPrefix();
    }

    /**
     * 关于修修兽
     *
     * @throws  \Exception
     * @return  array
     */
    public static function about () {
        return self::getClass()->about();
    }

    /**
     * 获取照片信息
     *
     * @param  int $id 照片id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhoto (int $id) {
        return self::getClass()->getPhoto([
            "id" => $id,
        ]);
    }

    /**
     * 事件记录
     *
     * @param  int $eventId 事件id [Original type uint] [ require true ]
     * @param  array $data 记录数据 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function eventLog (int $eventId, array $data = []) {
        return self::getClass()->eventLog([
            "eventId" => $eventId,
            "data" => $data,
        ]);
    }

    /**
     * 获取自身权限信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getSelfPermission () {
        return self::getClass()->getSelfPermission();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectShowPic', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectShowPic', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}